//
//  COGlyph.h
//  GSFontTools
//
//  Created by Georg Seifert on 01.03.12.
//  Copyright (c) 2012 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

@class COFont;
@class OTBasePen;

@interface COGlyph : NSObject
// class Glyph(object):
{
	NSString *_name;
	id _source;
	CGFloat _width;
	COFont *_font;
	NSUInteger _index;
	NSBezierPath *_bezierPath;
}
@property (nonatomic, retain) NSString *name;
@property (nonatomic, retain) id source;
@property (nonatomic, readonly) CGFloat width;
@property (nonatomic, assign) COFont *font;
@property (nonatomic, assign) NSUInteger index;
@property (nonatomic, retain) NSBezierPath *bezierPath;

- (id)initWithName:(NSString *)name index:(NSUInteger)idx TTGlyph:(id)source parent:(COFont *)parent;
- (void)draw:(OTBasePen *)pen;
- (NSRect)bounds;

@end
